<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;
    protected $fillable = array('payment', 'total_price', 'delivery_address', 'note', 'no_order', 'status', 'resturant_id', 'food_id');

    public function clients()
    {
        return $this->belongsToMany('App\Models\Client');
    }

    public function food()
    {
        return $this->belongsTo('App\Models\Food');
    }

    public function resturant()
    {
        return $this->belongsTo('App\Models\Client');
    }

}